' JB_Spectrum JetPac By Jim Bagley 
'

CON

'uncomment the '{ block which suites your system.

{ Hybrid Defines
        _CLKMODE                = xtal1 + pll16x
        _XINFREQ                = 5_000_000 + 0000
USE_TV_ON_PIN_24                = 1      ' usually 0 for Proto/Demo boards ( Spectrum.Start(12) ) and 1 for Hydra ( Spectrum.Start(24) ) 
KEYSPIN                         = 12 
' NES bit encodings for NES gamepad 0
NES_RIGHT  = %00000000_00001000
NES_LEFT   = %00000000_00000100
NES_DOWN   = %00000000_00000010
NES_UP     = %00000000_00000001
NES_START  = %00000000_00100000
NES_SELECT = %00000000_00100000
NES_B      = %00000000_10000000
NES_A      = %00000000_10000000
'}
{ Hydra Defines
        _CLKMODE                = xtal1 + pll8x
        _XINFREQ                = 10_000_000 + 0000
USE_TV_ON_PIN_24                = 1      ' usually 0 for Proto/Demo boards ( Spectrum.Start(12) ) and 1 for Hydra ( Spectrum.Start(24) )
KEYSPIN                         = 13 
' NES bit encodings for NES gamepad 0
NES_RIGHT  = %00000000_00000001
NES_LEFT   = %00000000_00000010
NES_DOWN   = %00000000_00000100
NES_UP     = %00000000_00001000
NES_START  = %00000000_00010000
NES_SELECT = %00000000_00100000
NES_B      = %00000000_01000000
NES_A      = %00000000_10000000
'}
'{ Proto/Demoboard Defines
        _CLKMODE                = xtal1 + pll16x
        _XINFREQ                = 5_000_000
USE_TV_ON_PIN_24                = 1      ' usually 0 for Proto/Demo boards ( Spectrum.Start(12) ) and 1 for Hydra ( Spectrum.Start(24) )
'KEYSPIN                         = 26
' NES bit encodings for NES gamepad 0
NES_RIGHT  = %00000000_00000001
NES_LEFT   = %00000000_00000010
NES_DOWN   = %00000000_00000100
NES_UP     = %00000000_00001000
NES_START  = %00000000_00010000
NES_SELECT = %00000000_00100000
NES_B      = %00000000_01000000
NES_A      = %00000000_10000000
'}

CON
  NUMBULLETS = 4
  NUMBADDIES = 8
  NUMPLOOMS = 10 'NUMBADDIES

  STARTLEVEL = 0

Con '------------------------ Hive-Parameter --------------------------------------
  'signaldefinitionen bellatrixix

#0,     D0,D1,D2,D3,D4,D5,D6,D7                         'datenbus
#8,     BEL_VGABASE                                     'vga-signale (8pin)
#16,    BEL_KEYBC,BEL_KEYBD                             'keyboard-signale
#18,    BEL_MOUSEC,BEL_MOUSED                           'maus-signale
#20,    BEL_VIDBASE                                     'video-signale(3pin)
#23,    BEL_SELECT                                      'belatrix-auswahlsignal
#24,    HBEAT                                           'front-led
        BUSCLK                                          'bustakt
        BUS_WR                                          '/wr - schreibsignal
        BUS_HS '                                        '/hs - quittungssignal


'          hbeat   --------+
'          clk     -------+|
'          /wr     ------+||
'          /hs     -----+||| +------------------------- /cs
'                       |||| |                 -------- d0..d7
DB_IN            = %00001001_00000000_00000000_00000000 'maske: dbus-eingabe
DB_OUT           = %00001001_00000000_00000000_11111111 'maske: dbus-ausgabe

M1               = %00000010_00000000_00000000_00000000
M2               = %00000010_10000000_00000000_00000000 'busclk=1? & /cs=0?

M3               = %00000000_00000000_00000000_00000000
M4               = %00000010_00000000_00000000_00000000 'busclk=0?


SEPIA            =1
VENATRIX         =2

BOARD            =0'VENATRIX                'Erweiterungskarten-Auswahl

VAR
  long  VSync
  long  frame
  long  scrptr

  long  txtx,txty,txtcol  

  long  ptr

  long  done

  long  joypadbits

  long  rfxcnt
  
  long  plrnum
  long  beforestart

  long  jetpacx
  long  jetpacy
  long  jetpacf
  long  jetpacg
  long  jetpacsprptr
  long  jetpackilled

  long  lives[2]

  long  bulletx[NUMBULLETS]
  long  bullety[NUMBULLETS]
  long  bulletxl[NUMBULLETS]
  long  bulletxs[NUMBULLETS]
  long  bulletdl[NUMBULLETS]

  long  ploomx[NUMPLOOMS]
  long  ploomy[NUMPLOOMS]
  long  ploomf[NUMPLOOMS]

  long  baddiesx[NUMBADDIES]
  long  baddiesy[NUMBADDIES]
  long  baddiesxs[NUMBADDIES]
  long  baddiesys[NUMBADDIES]
  long  baddiescnt[NUMBADDIES]
  long  baddiestmp[NUMBADDIES]

  long  SpritesInfo[( ( gfx#NUMSPRITES * gfx#SPRITEILEN ) / 4 ) * 3 ]

  long  gemx
  long  gemy
  long  gemtype

'player data for storing per life, ie storing for retrieval later, when swapping players
  long  shiptopx
  long  shiptopy
  long  shipmidx
  long  shipmidy
'4
  long  shipbotx
  long  shipboty
  long  shippal
  long  shipdir
'8
  long  fuelx
  long  fuely
  long  fuellevel
  long  fueldropable
'12
  long  gotfuel
  long  gotshipmid
  long  gotshiptop
  long  level
'16

  long  playerbackup[16]
OBJ
  Spectrum      : "JB_001_JLC_Spectrum_TV_010"
  key           : "keyboard"'"comboKeyboard"
  gfx           : "JB_Spectrum_Graphics_002"
  'hss           : "ym2413a_hss_v1"
CON
copymemsize = 16
  


con'---------------------------------- Hive-Bus-Funktionen
PRI bus_putchar(zeichen)                                'chip: ein byte an regnatix senden
''funktionsgruppe               : chip
''funktion                      : ein byte an regnatix senden
''eingabe                       : byte
''ausgabe                       : -

  waitpeq(M1,M2,0)                                      'busclk=1? & prop2=0?
  dira := db_out                                        'datenbus auf ausgabe stellen
  outa[7..0] := zeichen                                 'daten ausgeben
  outa[bus_hs] := 0                                     'daten gültig
  waitpeq(M3,M4,0)                                      'busclk=0?
  dira := db_in                                         'bus freigeben
  outa[bus_hs] := 1                                     'daten ungültig

PRI bus_putlong(wert)                                   'sub: long senden
''funktionsgruppe               : sub
''funktion                      : subprotokoll um einen long-wert an regnatix zu senden
''eingabe                       : 32bit wert der gesendet werden soll
''ausgabe                       : -
''busprotokoll                  : [put.byte1][put.byte2][put.byte3][put.byte4]
''                              : [  hsb    ][         ][         ][   lsb   ]

   bus_putchar(wert >> 24)                              '32bit wert senden hsb/lsb
   bus_putchar(wert >> 16)
   bus_putchar(wert >> 8)
   bus_putchar(wert)

PRI bus_getchar : zeichen                               'chip: ein byte von regnatix empfangen
''funktionsgruppe               : chip
''funktion                      : ein byte von regnatix empfangen
''eingabe                       : -
''ausgabe                       : byte
   'outa[hbeat]~~
   waitpeq(M1,M2,0)                                     'busclk=1? & prop2=0?
   zeichen := ina[7..0]                                 'daten einlesen
   outa[bus_hs] := 0                                    'daten quittieren
   waitpeq(M3,M4,0)                                     'busclk=0?
   outa[bus_hs] := 1
   'outa[hbeat]~
PUB FStart | x,y,i,j

'  hss.start 'Start HSS Engine
'  hss.hmus_load(@bgmusic) 'Load Hmus file into player.
'  hss.hmus_play 'Play loaded file.

  key.start(17,16)

  gfx.Start
  gfx.Setup(@Screen,@SpritesScreen)

  Spectrum.Start(@Screen, 0, @VSync, USE_TV_ON_PIN_24)
  scrptr:=@Screen

  repeat  10*60
    waitblank

  repeat
    Display_MainMenu

    level:=STARTLEVEL   

    jetpacx:=15<<3
    jetpacy:=20<<3
    jetpacf:=0
    jetpacg:=0
    jetpacsprptr:=0
    jetpackilled:=0
    
    plrnum:=0
    lives[0]:=4
    lives[1]:=0
    if p2gamesetting==$c7
      lives[1]:=5

    beforestart:=2*60

    shiptopx:=6<<3
    shiptopy:=7<<3
    shipmidx:=16<<3
    shipmidy:=10<<3
    shipbotx:=20<<3
    shipboty:=21<<3
    shippal:=$47
    shipdir:=0

    repeat i from 0 to NUMPLOOMS-1
      ploomy[i]:=0

    fuelx:=frame&$f0
    fuely:=-100
    fuellevel:=0
    fueldropable:=0
    gotfuel:=0
    gotshipmid:=0
    gotshiptop:=0

    gemx:=cnt&(28<<3)
    gemy:=-(256+(cnt&127))
    gemtype:=gemtypes[cnt&7]

    repeat i from 0 to NUMBULLETS-1
      bullety[i]:=-100

    repeat i from 0 to NUMBADDIES-1
      baddiesy[i]:=-100

    repeat i from 0 to copymemsize-1
      long[@playerbackup][i]:=long[@shiptopx][i]

    Display_GameScreen
    
    done:=0
    longfill( @SpritesInfo , 0 , ( ( gfx#NUMSPRITES * gfx#SPRITEILEN ) / 4 ) * 3 )
    repeat while not done

'      Spectrum.SetBorderColor(6)

      longfill( @SpritesInfo , 0 , gfx#NUMSPRITES * gfx#SPRITEILEN / 4 )
      ptr:=@SpritesInfo

      repeat i from 0 to NUMBADDIES-1
        word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+((8+((level&7)<<1))<<8+jetpacframes[(baddiesx[i]&6)>>1])
        if baddiesxs[i]<0
          word[ptr][gfx#SPRITEADDR]+=12
        word[ptr][gfx#SPRITEATTR]:=$2341+(i&3)
        word[ptr][gfx#SPRITEXPOS]:=baddiesx[i]
        word[ptr][gfx#SPRITEYPOS]:=baddiesy[i]
        ptr+=gfx#SPRITEILEN

      repeat i from 0 to NUMPLOOMS-1
        if ploomy[i]
          word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+((6+ploomf[i])<<8+26)
          word[ptr][gfx#SPRITEATTR]:=$2342
          word[ptr][gfx#SPRITEXPOS]:=ploomx[i]
          word[ptr][gfx#SPRITEYPOS]:=ploomy[i]
          ptr+=gfx#SPRITEILEN

      if gemy>16
        word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+gemoffsets[gemtype]
        word[ptr][gfx#SPRITEATTR]:=$2200+gempals[gemtype]
        word[ptr][gfx#SPRITEXPOS]:=gemx
        word[ptr][gfx#SPRITEYPOS]:=gemy
        ptr+=gfx#SPRITEILEN
        gempals[4]:=(frame&7)+$40
        gempals[1]:=(((frame>>4)&1)*6)+$40
         
      if shipdir
        word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+(0<<8+24+((level>>1)&6))
        word[ptr][gfx#SPRITEATTR]:=$6200+shippal
        word[ptr][gfx#SPRITEXPOS]:=shiptopx
        word[ptr][gfx#SPRITEYPOS]:=shiptopy
        ptr+=gfx#SPRITEILEN
        if shiptopy<14<<3
          i:=6<<8+30
          if ((frame)&12)
            i+=2<<8
          word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+i+((level>>1)&6)
          word[ptr][gfx#SPRITEATTR]:=$2242
          word[ptr][gfx#SPRITEXPOS]:=shiptopx
          word[ptr][gfx#SPRITEYPOS]:=shiptopy+56
          ptr+=gfx#SPRITEILEN
      else        
        word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+(0<<8+24+((level>>1)&6))
        word[ptr][gfx#SPRITEATTR]:=$2247
        word[ptr][gfx#SPRITEXPOS]:=shiptopx
        word[ptr][gfx#SPRITEYPOS]:=shiptopy
        ptr+=gfx#SPRITEILEN
        word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+(2<<8+24+((level>>1)&6))
        word[ptr][gfx#SPRITEATTR]:=$2247
        word[ptr][gfx#SPRITEXPOS]:=shipmidx
        word[ptr][gfx#SPRITEYPOS]:=shipmidy
        ptr+=gfx#SPRITEILEN
        word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+(4<<8+24+((level>>1)&6))
        word[ptr][gfx#SPRITEATTR]:=$2247
        word[ptr][gfx#SPRITEXPOS]:=shipbotx
        word[ptr][gfx#SPRITEYPOS]:=shipboty
        ptr+=gfx#SPRITEILEN

      if(shipdir==0)
        if (fuellevel)
          word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+(11<<8+30)
          word[ptr][gfx#SPRITEATTR]:=$0243+(fuellevel<<12)
          word[ptr][gfx#SPRITEXPOS]:=shiptopx
          word[ptr][gfx#SPRITEYPOS]:=shiptopy+((6-fuellevel)<<3)
          ptr+=gfx#SPRITEILEN

      if fuely=>16       
        word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+(6<<8)+jetpacframes[(fuelx>>1)&3]
        word[ptr][gfx#SPRITEATTR]:=$2343
        word[ptr][gfx#SPRITEXPOS]:=fuelx
        word[ptr][gfx#SPRITEYPOS]:=fuely
        ptr+=gfx#SPRITEILEN

      if jetpackilled
        long[jetpacsprptr+( gfx#NUMSPRITES * gfx#SPRITEILEN )][0]:=0
        long[jetpacsprptr+( gfx#NUMSPRITES * gfx#SPRITEILEN )][1]:=0
      jetpacsprptr:=ptr
      if shipdir==0 and beforestart==0 and jetpackilled==0
        word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+jetpacframes[jetpacf]
        word[ptr][gfx#SPRITEATTR]:=$3347
        word[ptr][gfx#SPRITEXPOS]:=jetpacx
        word[ptr][gfx#SPRITEYPOS]:=jetpacy
        ptr+=gfx#SPRITEILEN

      word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+(17<<8+24)
      word[ptr][gfx#SPRITEATTR]:=$1344
      word[ptr][gfx#SPRITEXPOS]:=24<<3
      word[ptr][gfx#SPRITEYPOS]:=6<<3
      ptr+=gfx#SPRITEILEN
      word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+(17<<8+27)
      word[ptr][gfx#SPRITEATTR]:=$1344
      word[ptr][gfx#SPRITEXPOS]:=27<<3
      word[ptr][gfx#SPRITEYPOS]:=6<<3
      ptr+=gfx#SPRITEILEN

      word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+(17<<8+24)
      word[ptr][gfx#SPRITEATTR]:=$1344
      word[ptr][gfx#SPRITEXPOS]:=4<<3
      word[ptr][gfx#SPRITEYPOS]:=9<<3
      ptr+=gfx#SPRITEILEN
      word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+(17<<8+27)
      word[ptr][gfx#SPRITEATTR]:=$1344
      word[ptr][gfx#SPRITEXPOS]:=7<<3
      word[ptr][gfx#SPRITEYPOS]:=9<<3
      ptr+=gfx#SPRITEILEN

      word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+(18<<8+24)
      word[ptr][gfx#SPRITEATTR]:=$1244
      word[ptr][gfx#SPRITEXPOS]:=15<<3
      word[ptr][gfx#SPRITEYPOS]:=12<<3
      ptr+=gfx#SPRITEILEN
      word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+(18<<8+26)
      word[ptr][gfx#SPRITEATTR]:=$1244
      word[ptr][gfx#SPRITEXPOS]:=17<<3
      word[ptr][gfx#SPRITEYPOS]:=12<<3
      ptr+=gfx#SPRITEILEN

      word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+(17<<8+24)
      word[ptr][gfx#SPRITEATTR]:=$1346
      word[ptr][gfx#SPRITEXPOS]:=0<<3
      word[ptr][gfx#SPRITEYPOS]:=23<<3
      ptr+=gfx#SPRITEILEN
      repeat i from 3 to 27 step 3
        word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+(17<<8+25)
        word[ptr][gfx#SPRITEATTR]:=$1346
        word[ptr][gfx#SPRITEXPOS]:=i<<3
        word[ptr][gfx#SPRITEYPOS]:=23<<3
        ptr+=gfx#SPRITEILEN
      word[ptr][gfx#SPRITEADDR]:=@SpritesScreen+(17<<8+28)
      word[ptr][gfx#SPRITEATTR]:=$1246
      word[ptr][gfx#SPRITEXPOS]:=30<<3
      word[ptr][gfx#SPRITEYPOS]:=23<<3
      ptr+=gfx#SPRITEILEN

'      Spectrum.SetBorderColor(2)

      joypadbits:=NES_Read_Gamepad

      waitblank

'      Spectrum.SetBorderColor(0)

      gfx.DoSprites(@SpritesInfo)

      repeat i from 0 to NUMBULLETS-1
        if bullety[i]>16
          if bulletxl[i]>0  and bulletxl[i]<bulletdl[i]
            byte[scrptr][(bullety[i]<<5)+((bulletx[i]               )&31)]:=%11111111
          if bulletxl[i]>5  and bulletxl[i]<bulletdl[i]+5
            byte[scrptr][(bullety[i]<<5)+((bulletx[i]-bulletxs[i]*5 )&31)]:=%11111100
          if bulletxl[i]>10 and bulletxl[i]<bulletdl[i]+10
            byte[scrptr][(bullety[i]<<5)+((bulletx[i]-bulletxs[i]*10)&31)]:=%11110000
          if bulletxl[i]>15 and bulletxl[i]<bulletdl[i]+15
            byte[scrptr][(bullety[i]<<5)+((bulletx[i]-bulletxs[i]*15)&31)]:=%00000000

'      Spectrum.SetBorderColor(1)

      if (frame&3)==1
        repeat i from 0 to NUMPLOOMS-1
          if ploomy[i]
            ploomf[i]+=2
            if ploomf[i]>8
              ploomy[i]:=0

      if shipdir==0 and beforestart==0 and jetpackilled==0
        if (frame&1)==0
          if key.keystate($c2) or joypadbits&NES_UP
            if jetpacf&8
              jetpacf&=7
              jetpacg--
              jetpacy--
              addploom(jetpacx,jetpacy+9)
            if jetpacg>-3
              jetpacg--
        i:=0
        if jetpacf&8
          i:=1
        if (frame&i)==0
          if key.keystate($c0) or joypadbits&NES_LEFT
            jetpacx-=2
            if jetpacx==$50-2 and jetpacy>$28 and jetpacy<$50
              jetpacx+=2
            if jetpacx==$98-2 and jetpacy>$48 and jetpacy<$68
              jetpacx+=2
            if jetpacx==$f0-2 and jetpacy>$18 and jetpacy<$38
              jetpacx+=2
            jetpacf:=(((jetpacx&6)>>1)&3)|4
          if key.keystate($c1) or joypadbits&NES_RIGHT
            jetpacx+=2
            if jetpacx==$10-2 and jetpacy>$28 and jetpacy<$50
              jetpacx-=2
            if jetpacx==$68-2 and jetpacy>$48 and jetpacy<$68
              jetpacx-=2
            if jetpacx==$b0-2 and jetpacy>$18 and jetpacy<$38
              jetpacx-=2
            jetpacf:=(((jetpacx&6)>>1)&3)
          jetpacx&=255

        if (frame&3)==0
          if key.keystate($f2) or key.keystate($f3) or joypadbits&NES_A
            repeat i from 0 to NUMBULLETS-1
              if bullety[i]<16
                if jetpacf&4
                  bulletxs[i]:=-1
                else
                  bulletxs[i]:=1
                bulletx[i]:=jetpacx>>3+1
                bullety[i]:=jetpacy+10
                bulletxl[i]:=0
                bulletdl[i]:=((frame>>2)&3)+20
                i:=NUMBULLETS
                bus_putchar(1)
                'hss.sfx_play(2, @TeleportFX)

        jetpacy+=jetpacg
        if (frame&3)==0
          if jetpacg<4
            jetpacg++

        if jetpacy=>20<<3
          jetpacy:=20<<3
          jetpacg:=0
          jetpacf|=8
        if jetpacy<2<<3
          jetpacy:=2<<3
          jetpacg:=0
          
        if jetpacx=>$10-2 and jetpacx=<$50-2 and jetpacy>$30 and jetpacy<$50
          if jetpacy<$40
            jetpacy:=$30
            jetpacf|=8
          else
            jetpacy:=$50
        if jetpacx=>$68-2 and jetpacx=<$98-2 and jetpacy>$48 and jetpacy<$68
          if jetpacy<$58
            jetpacy:=$48
            jetpacf|=8
          else
            jetpacy:=$68
        if jetpacx=>$b0-2 and jetpacx=<$f0-2 and jetpacy>$18 and jetpacy<$38
          if jetpacy<$28
            jetpacy:=$18
            jetpacf|=8
          else
            jetpacy:=$38

      if shipdir==0
        if (frame&1)==0
          shipmidy++
          if (shipmidx+4&$f8)<>20<<3
            if CanItMove(shipmidx,shipmidy)<>shipmidy
              shipmidy--
          shiptopy++
          if (shiptopx+4&$f8)<>20<<3
            if CanItMove(shiptopx,shiptopy)<>shiptopy
              shiptopy--
        if (shipmidx&$f8)==20<<3
          shipmidx:=20<<3
          if shipmidy>19<<3
            shipmidy:=19<<3
            if (shiptopx&$f8)==20<<3
              shiptopx:=20<<3
              if shiptopy>17<<3
                shiptopy:=17<<3
                if fueldropable==0
                  bus_putchar(2)
                  'hss.sfx_play(2, @WaterDropFX)
                fueldropable:=1
            else
              if beforestart==0 and shipdir==0 and ( ||(jetpacx-shiptopx)<16 or || (jetpacx-shiptopx)>240) and jetpacy+24>shiptopy and shiptopy+16>jetpacy
                shiptopx:=jetpacx
                shiptopy:=jetpacy+8
                if gotshiptop==0
                  gotshiptop:=1
                  addscore(@add100txt)
                  bus_putchar(2)
                  'hss.sfx_play(2, @WaterDropFX)
        else                                            
          if beforestart==0 and shipdir==0 and ( ||(jetpacx-shipmidx)<16 or ||(jetpacx-shipmidx)>240) and jetpacy+24>shipmidy and shipmidy+16>jetpacy
            shipmidx:=jetpacx
            shipmidy:=jetpacy+8
            if gotshipmid==0
              gotshipmid:=1
              addscore(@add100txt)
              bus_putchar(2)
              'hss.sfx_play(2, @WaterDropFX)

      gemy++
      if gemy>16
        gemy:=CanItMove(gemx,gemy)
      if beforestart==0 and shipdir==0 and ( ||(jetpacx-gemx)<16 or ||(jetpacx-gemx)>240) and jetpacy+24>gemy and gemy+12>jetpacy
        gemx:=cnt&(28<<3)
        gemy:=-(256+(cnt&127))
        gemtype:=gemtypes[frame&7]
        addscore(@add250txt)
        bus_putchar(3)
        'hss.sfx_play(2, @HeartBeatFX)
              
      if fueldropable<>0 and fuellevel<6            
        fuely++
      if (fuelx+4&$f8)<>20<<3
        if beforestart==0 and shipdir==0 and ( ||(jetpacx-fuelx)<16 or ||(jetpacx-fuelx)>240) and jetpacy+24>fuely and fuely+12>jetpacy
          fuelx:=jetpacx
          fuely:=jetpacy+8
          if gotfuel==0
            gotfuel:=1
            addscore(@add100txt)
            bus_putchar(2)
            'hss.sfx_play(2, @WaterDropFX)
      else
        fuelx:=20<<3
        if fuely=>20<<3+8
          bus_putchar(2)
          'hss.sfx_play(2, @WaterDropFX)
          fuelx:=frame&$f0
          fuely:=-100
          gotfuel:=0
          if fuellevel<5
            fuellevel++
          else
            fuellevel:=6
            shippal:=$43
            fueldropable:=0
      if fueldropable<>0 and fuellevel<6           
        fuely:=CanItMove(fuelx,fuely)
      if(shipdir==0 and fuellevel==6)
        if ( ||(jetpacx-shiptopx)<16 or || (jetpacx-shiptopx)>240) and jetpacy>18<<3
          shipdir:=-1

      if frame&3==0
        if (shipdir<>0)
          if frame&15==0
            rfxcnt++
            if rfxcnt==1
              if (shipdir>0)
                bus_putchar(4)
                'hss.sfx_play(2, @RocketFX1)
              else
                bus_putchar(6)
                'hss.sfx_play(2, @RocketFX3)
            if rfxcnt==2
              bus_putchar(5)
              'hss.sfx_play(2, @RocketFX2)
            if rfxcnt=>3
              if (shipdir>0)
                bus_putchar(6)
                'hss.sfx_play(2, @RocketFX3)
              else
                bus_putchar(4)
                'hss.sfx_play(2, @RocketFX1)
              rfxcnt:=0
              
          shiptopy+=shipdir
          if shiptopy==0
            shipdir:=1
            shippal:=$47
            repeat i from 0 to NUMBADDIES-1
              baddiesy[i]:=-32
            level++
            if level&3==0
              shiptopx:=6<<3
              shiptopy:=7<<3
              shipmidx:=16<<3
              shipmidy:=10<<3
              shipbotx:=20<<3
              shipboty:=21<<3
              shipdir:=0
              fuellevel:=0
              fueldropable:=0
              gotfuel:=0
              jetpacx:=15<<3
              jetpacy:=20<<3
              jetpacf:=0
              jetpacg:=0
              beforestart:=2*60
              Display_GameScreen
                  
          if shiptopy==17<<3
            shipdir:=0
            fuellevel:=0
            fueldropable:=1
            gotfuel:=0
            jetpacx:=15<<3
            jetpacy:=20<<3
            jetpacf:=0
            jetpacg:=0
            beforestart:=2*60

      repeat i from 0 to NUMBULLETS-1
        if bullety[i]>16
          bulletx[i]+=bulletxs[i]
          bulletxl[i]++
          if bulletxl[i]=>bulletdl[i]+15 
            bullety[i]:=-100
          if bulletxl[i]<bulletdl[i]
            if CanItMoveBul(bulletx[i]&31,bullety[i]>>3)==1
              bulletdl[i]:=bulletxl[i]

      if beforestart==0
        Move_Baddies
         
      if beforestart==0
        repeat i from 0 to NUMBULLETS-1
          if bullety[i]>16 and bulletxl[i]<bulletdl[i]
            repeat j from 0 to NUMBADDIES-1
              if baddiesy[j]>0
                x:=||(bulletx[i]<<3-baddiesx[j])
                if ( x<16 or x>240) and bullety[i]+2>baddiesy[j] and baddiesy[j]+16>bullety[i]
                  bulletdl[i]:=bulletxl[i]
                  bus_putchar(7)
                  'hss.sfx_play(2, @KillBadFX1)
                  addploom(baddiesx[j]-baddiesxs[j],baddiesy[j]-baddiesys[j])
                  baddiesy[j]:=-100
                  addscore(@baddyscorestxt+((level&7)<<3))

      if shipdir==0 and beforestart==0 and frame&3==0      
        repeat i from 0 to NUMBADDIES-1
          if baddiesy[i]<0
            Init_Baddy(i)
            i:=NUMBADDIES
            
      if key.keystate("p")
        i:=0
        repeat while i==0
          if key.keystate("p")==0
            i:=1
          if key.keystate($CB)
            done:=1
            i:=1
        i:=0
        repeat while i==0
          if key.keystate("p")
            i:=1
          if key.keystate($CB)
            done:=1
            i:=1
        i:=0
        repeat while i==0
          if key.keystate("p")==0
            i:=1
          if key.keystate($CB)
            done:=1
            i:=1
          
      if key.keystate($CB)
        done:=1

      if beforestart
        beforestart--
        if plrnum==0
          byte[scrptr+6144+3 ][0]:=$c7
          word[scrptr+6144+4 ][0]:=$c7c7
        if plrnum==1
          byte[scrptr+6144+27][0]:=$c7
          word[scrptr+6144+28][0]:=$c7c7
        if beforestart==0
          if plrnum==0
            byte[scrptr+6144+3 ][0]:=$47
            word[scrptr+6144+4 ][0]:=$4747
          if plrnum==1
            byte[scrptr+6144+27][0]:=$47
            word[scrptr+6144+28][0]:=$4747
          repeat i from 0 to NUMBADDIES-1
            Init_Baddy(i)
          gemx:=cnt&(28<<3)
          gemy:=-(256+(cnt&127))
          gemtype:=gemtypes[frame&7]

      if jetpackilled
        jetpackilled--
        if jetpackilled==0
          if lives[plrnum]==0
            Display_GameOver
          if p2gamesetting==$c7
            plrnum:=1-plrnum
            if lives[plrnum]==0
              plrnum:=1-plrnum
            else
              repeat i from 0 to copymemsize-1
                j:=long[@playerbackup][i]            
                long[@playerbackup][i]:=long[@shiptopx][i]
                long[@shiptopx][i]:=j            
          if lives[plrnum]==0
            done:=1
          lives[plrnum]--
          if done==0  
            Display_GameScreen
          beforestart:=2*60
          jetpacx:=15<<3
          jetpacy:=20<<3
          jetpacf:=0
          jetpacg:=0
          repeat i from 0 to NUMBADDIES-1
            baddiesy[i]:=-100
           
'    if mouse.button(0)
'      hss.sfx_play(1, @TeleportFX) 'Play a sound effect on FX channel (1)
'    if mouse.button(1)
'      hss.sfx_play(2, @SoundFX1) 'Play a sound effect on FX channel (2) 
'    if mouse.button(3)
'      hss.hmus_stop
'    if mouse.button(4)
'      hss.hmus_play 'Play loaded file.
'    if mouse.button(2)
'      hss.hmus_pause

PUB Kill_Baddy(number)
  addploom(baddiesx[number]-baddiesxs[number],baddiesy[number]-baddiesys[number])
  bus_putchar(7)
  'hss.sfx_play(2, @KillBadFX1)
  baddiesy[number]:=-100

'0=meteor  'left-right + fall
'1=fluffy  'bounce around
'2=balloon 'bounce around with random
'3=plane   'float on edge and come in when player on sameish height
'4=uf0     'homing
'5=Dpad    'bounce around
'6=ship    'left-right + fall
'7=furby   'homing
PUB Move_Baddies | i
  repeat i from 0 to NUMBADDIES-1
    if baddiesy[i]>0

      if level&7==0 or level&7==6
        baddiesx[i]+=baddiesxs[i]
        baddiesx[i]&=255
        if frame&1==0
          baddiesy[i]+=baddiesys[i]
        if CanItMove(baddiesx[i],baddiesy[i])<>baddiesy[i]
          Kill_Baddy(i)

      if level&7==1 or level&7==5
        baddiesx[i]+=baddiesxs[i]
        if CanItMoveX(baddiesx[i],baddiesy[i])<>baddiesx[i]
          baddiesxs[i]:=-baddiesxs[i]
          baddiesx[i]+=baddiesxs[i]
        baddiesy[i]+=baddiesys[i]
        if CanItMove(baddiesx[i],baddiesy[i])<>baddiesy[i]
          baddiesys[i]:=-baddiesys[i]
          baddiesy[i]+=baddiesys[i]
      
      if level&7==2
        baddiesy[i]+=baddiesys[i]
        if CanItMove(baddiesx[i],baddiesy[i])<>baddiesy[i]
          baddiesys[i]:=-baddiesys[i]
          baddiesy[i]+=baddiesys[i]
        baddiesx[i]+=baddiesxs[i]
        if CanItMoveX(baddiesx[i],baddiesy[i])<>baddiesx[i]
          baddiesxs[i]:=-baddiesxs[i]
          baddiesx[i]+=baddiesxs[i]
        if baddiescnt[i]==0
          baddiesys[i]:=(cnt&3)
          if baddiesys[i]==3
            baddiesys[i]:=1
          baddiesys[i]--
          baddiescnt[i]:=(cnt&31)+15

      if level&7==3
        if baddiestmp[i]==0
          baddiescnt[i]++
          if baddiescnt[i]&127==0
            baddiesys[i]:=-baddiesys[i]
          if frame&3==0
            baddiesy[i]+=baddiesys[i]
            if baddiesy[i]<$18
              baddiesys[i]:=||baddiesys[i]
              baddiescnt[i]:=0
          if jetpacy+24>baddiesy[i] and baddiesy[i]+16>jetpacy
            baddiestmp[i]:=1
        else
          if frame&3==0
            if jetpacy+8>baddiesy[i]
              baddiesy[i]++
            else
              baddiesy[i]--
            if CanItMove(baddiesx[i],baddiesy[i])<>baddiesy[i]
              Kill_Baddy(i)
          baddiesx[i]+=baddiesxs[i]
          if CanItMoveX(baddiesx[i],baddiesy[i])<>baddiesx[i]
            Kill_Baddy(i)

      if level&7==4 or level&7==7 
        if frame&1==0
          if jetpacy+8>baddiesy[i]
            if baddiesys[i]<2
              baddiesys[i]++
          else               
            if baddiesys[i]>-2
              baddiesys[i]--
          baddiesy[i]+=baddiesys[i]
          if CanItMove(baddiesx[i],baddiesy[i])<>baddiesy[i]
            baddiesys[i]:=-baddiesys[i]
            baddiesy[i]+=baddiesys[i]
         
          if ((jetpacx-baddiesx[i])&128)==0
            if baddiesxs[i]<2
              baddiesxs[i]++
          else
            if baddiesxs[i]>-2
              baddiesxs[i]--
          baddiesx[i]+=baddiesxs[i]
          if CanItMoveX(baddiesx[i],baddiesy[i])<>baddiesx[i]
            baddiesxs[i]:=-baddiesxs[i]
            baddiesx[i]+=baddiesxs[i]

    baddiesx[i]&=255
    if baddiesy[i]>0 and jetpackilled==0 and shipdir==0
      if ( ||(jetpacx-baddiesx[i])<16 or ||(jetpacx-baddiesx[i])>240) and jetpacy+24>baddiesy[i] and baddiesy[i]+16>jetpacy
        jetpackilled:=30
        addploom(baddiesx[i]-baddiesxs[i],baddiesy[i]-baddiesys[i])
        addploom(jetpacx,jetpacy+8)
        bus_putchar(7)
        'hss.sfx_play(2, @KillBadFX1)
        baddiesy[i]:=-100
         
PUB Init_Baddy(num)
  baddiesx[num]:=$f8
  baddiesy[num]:=cnt&127+$18
  baddiestmp[num]:=0
  baddiescnt[num]:=0
  if level&7==0 or level&7==6
    baddiesxs[num]:=(cnt>>9)&2-1
    baddiesys[num]:=(cnt>>10)&1
  if level&7==1 or level&7==5
    baddiesxs[num]:=(cnt>>9)&2-1
    baddiesys[num]:=(cnt>>10)&2-1
  if level&7==2
    baddiesxs[num]:=(cnt>>9)&2-1
    baddiesys[num]:=(cnt>>10)&2-1
    baddiestmp[num]:=((cnt>>3)&31)+15
  if level&7==3
    baddiesxs[num]:=(cnt>>9)&2-1
    if baddiesy[num]&128
      baddiesys[num]:=-1
    else
      baddiesys[num]:=-1
  if level&7==4 or level&7==7
    baddiesxs[num]:=(cnt>>9)&2-1
    baddiesys[num]:=(cnt>>10)&2-1
   
PUB addploom(x,y) | plmcnt
  repeat plmcnt from 0 to NUMPLOOMS-1
    if ploomy[plmcnt]==0
      ploomx[plmcnt]:=x
      ploomy[plmcnt]:=y
      ploomf[plmcnt]:=0
      return      

PUB CanItMove(x,y) : newY
  newY:=y
  if y=>20<<3+8
    newY:=20<<3+8
  if y<2<<3+8
    newY:=2<<3+8
      
  if x=>$10-2 and x<$50 and y>$30+8 and y<$50+8
    if y<$40+8
      newY:=$30+8
    else
      newY:=$50+8
  if x=>$68-2 and x<$98 and y>$48+8 and y<$68+8
    if y<$58+8
      newY:=$48+8
    else
      newY:=$68+8
  if x=>$b0-2 and x<$f0 and y>$18+8 and y<$38+8
    if y<$28+8
      newY:=$18+8
    else
      newY:=$38+8
   
PUB CanItMoveX(x,y) : newX
  newX:=x
      
  if x=>$10-2 and x<$50 and y>$30+8 and y<$50+8
    if x<$30                
      newX:=$10-2
    else
      newX:=$50
  if x=>$68-2 and x<$98 and y>$48+8 and y<$68+8
    if x<$80
      newX:=$68-2
    else
      newX:=$98
  if x=>$b0-2 and x<$f0 and y>$18+8 and y<$38+8
    if x<$d0
      newX:=$b0-2
    else
      newX:=$f0
   
PUB CanItMoveBul(x,y) : tf
  tf:=0
  if x=>4 and x<10 and y==9
    tf:=1
  if x=>15 and x<19 and y==12
    tf:=1
  if x=>24 and x<30 and y==6
    tf:=1
   
PUB waitblank
  VSync:=0
  repeat while VSync==0
  frame++

PUB print(p,x,y,col)
  txtx:=x
  txty:=y
  txtcol:=col
  repeat while byte[p][0]<>0
    print_char(byte[p][0])
    p++    

PUB print_char(p) | y
  repeat y from 0 to 7
    byte[scrptr][(((txty<<3)+y)<<5)+txtx]:=font[(p-32)<<3+y] 'uncomment this one for screen type 0
'    byte[scrptr][((txty&7)<<5)+((txty&$18)<<8)+(y<<8)+txtx]:=font[(p-32)<<3+y]    'uncomment this one for screen type 1
  byte[scrptr][6144+(txty<<5)+txtx]:=txtcol
  txtx++
  if txtx>31
    txtx:=0
    if txty<24
      txty++

PUB print_cell(dx,dy,sx,sy,at) | y
  repeat y from 0 to 7
    byte[scrptr][(((dy<<3)+y)<<5)+dx]:=byte[@SpritesScreen][(((sy<<3)+y)<<5)+sx] 'uncomment this one for screen type 0
  byte[scrptr][6144+(dy<<5)+dx]:=at

PUB Display_GameOver
  waitblank

  longfill(scrptr+6144,0,768/4)
  longfill(scrptr,0,6144/4)
  longfill(scrptr+6144,$47474747,768/4)

  checkhiscore

  print(string("1UP"),3,0,$47)
  print(string("HI"),15,0,$45)
  print(string("2UP"),27,0,$47)
  print(@score1txt,1,1,$46)
  print(@hiscoretxt,13,1,$46)
  print(@score2txt,25,1,$46)

  print(string("GAME OVER PLAYER "),7,12,$47)
  print_char(plrnum+"1")

  repeat 5*60
    waitblank

PUB Display_GameScreen | x,y
  waitblank

  longfill(scrptr+6144,0,768/4)
  longfill(scrptr,0,6144/4)
  longfill(scrptr+6144,$47474747,768/4)

  print(string("1UP"),3,0,$47)
  print(string("HI"),15,0,$45)
  print(string("2UP"),27,0,$47)
  print(@score1txt,1,1,$46)
  print(@hiscoretxt,13,1,$46)
  print(@score2txt,25,1,$46)

  if lives[0]
    lives1text[0]:=lives[0]+"0"
    print(@lives1text,8,0,$47)
    print_cell(9,0,29,9,$47)
  if p2gamesetting==$c7 and lives[1]
    lives2text[0]:=lives[1]+"0"
    print(@lives2text,22,0,$47)
    print_cell(23,0,29,9,$47)

  print_cell(24,6,29,10,$44)
  repeat x from 25 to 28
    print_cell(x,6,30,10,$44)
  print_cell(29,6,31,10,$44)

  print_cell(4,9,29,10,$44)
  repeat x from 5 to 8
    print_cell(x,9,30,10,$44)
  print_cell(9,9,31,10,$44)

  print_cell(15,12,29,10,$44)
  repeat x from 16 to 17
    print_cell(x,12,30,10,$44)
  print_cell(18,12,31,10,$44)

  print_cell(0,23,29,10,$46)
  repeat x from 1 to 30
    print_cell(x,23,30,10,$46)
  print_cell(31,23,31,10,$46)

PUB Display_MainMenu
  waitblank

  longfill(scrptr+6144,0,768/4)
  longfill(scrptr,0,6144/4)
  longfill(scrptr+6144,$47474747,768/4)

  checkhiscore
  bytefill(@score1txt,"0",6)
  bytefill(@score2txt,"0",6)

  print(string("1UP"),3,0,$47)
  print(string("HI"),15,0,$45)
  print(string("2UP"),27,0,$47)
  print(@score1txt,1,1,$46)
  print(@hiscoretxt,13,1,$46)
  print(@score2txt,25,1,$46)
  print(string("JETPAC GAME SELECTION"),6,4,$47)
  print(string("1   1 PLAYER GAME"),6,7,p1gamesetting)
  print(string("2   2 PLAYER GAME"),6,9,p2gamesetting)
  print(string("3   KEYBOARD"),6,11,keyboardsetting)
  print(string("4   JOYSTICK"),6,13,joysticksetting)
  print(string("5   START GAME"),6,15,$47)
  print(string("PORTED FOR HIVE-COMPUTER"),4,20,$42)
  print(string("BY ZILLE9"),11,21,$41)
  print(string("PROP VERSION RE-CODED BY BAGGERS"),0,23,$47)

  repeat
    waitblank
    joypadbits:=NES_Read_Gamepad
    if key.keystate("1")
      p1gamesetting:=$c7
      p2gamesetting:=$47
    if key.keystate("2")
      p1gamesetting:=$47
      p2gamesetting:=$c7
    if key.keystate("3")
      keyboardsetting:=$c7
      joysticksetting:=$47
    if key.keystate("4")
      keyboardsetting:=$47
      joysticksetting:=$c7
    if key.keystate("5") or joypadbits&NES_A
      return
    bytefill(scrptr+6144+7<<5+6,p1gamesetting,17)
    bytefill(scrptr+6144+9<<5+6,p2gamesetting,17)
    bytefill(scrptr+6144+11<<5+6,keyboardsetting,12)
    bytefill(scrptr+6144+13<<5+6,joysticksetting,12)      

pub checkhiscore | x,c
  repeat x from 0 to 5
    if score1txt[x]<hiscoretxt[x]
      x:=6
    if x<6
      if score1txt[x]>hiscoretxt[x]
        bytemove(@hiscoretxt,@score1txt,6)
        print(@hiscoretxt,13,1,$46)
        x:=6

  repeat x from 0 to 5
    if score2txt[x]<hiscoretxt[x]
      x:=6
    if x<6
      if score2txt[x]>hiscoretxt[x]
        bytemove(@hiscoretxt,@score2txt,6)
        print(@hiscoretxt,13,1,$46)
        x:=6
        
pub addscore(addstring) | x,c,el
  el:=0
  c:=0
  if plrnum==0
    if score1txt[2]=="3"
      el++
    repeat x from 0 to 5
      score1txt[5-x]+=(byte[addstring][5-x]-"0")+c
      c:=0
      if score1txt[5-x]>"9"
        score1txt[5-x]-=10
        c:=1 
    print(@score1txt,1,1,$46)
    if score1txt[2]=="4"
      el++
    if el==2
      lives[0]++
      lives1text[0]:=lives[0]+"0"
      print(@lives1text,8,0,$47)
  else
    if score2txt[2]=="3"
      el++
    repeat x from 0 to 5
      score2txt[5-x]+=(byte[addstring][5-x]-"0")+c
      c:=0
      if score2txt[5-x]>"9"
        score2txt[5-x]-=10
        c:=1 
    print(@score2txt,25,1,$46)
    if score2txt[2]=="4"
      el++
    if el==2
      lives[1]++
      lives2text[0]:=lives[1]+"0"
      print(@lives2text,22,0,$47)
     
PUB NES_Read_Gamepad : pad_bits   |       i,nes_bits

'This is intended as a replacement for code which contain
'an embedded NES_Read_Gamepad function.  Simple overwrite
'the entire 'PUB NES_Read_Gamepad' with the contents of this file.

'Adjust remarked entries as required.
'This is designed for the adapter: 'atari_vga_schematic.jpg"
    if board>0
       bus_putchar(223)                    'Joystickabfrage befehl
       bus_putchar(1)                      'Joy1
       bus_putchar(board)
       nes_bits:= bus_getchar'c << 8

'  if nes_bits == 32 'Read Fire alternate between Select & Start
'     pad_bits := %00010000

      if nes_bits == 8 'Read RIGHT show as NES_DPAD Right
         pad_bits := %00000001

      if nes_bits == 4 'Read LEFT  show as NES0_DPAD Left
         pad_bits := %00000010

 ' if nes_bits == 2 'Read DOWN  show as NES0_B button
 '    pad_bits := %01000000

      if nes_bits == 2 'Read Down  show as NES0_DPAD down
         pad_bits := %00000100

      if nes_bits == 32 'Read UP    show as NES0_A button
         pad_bits := %10000000

      if nes_bits == 1 'Read UP    show as NES0_DPAD up
         pad_bits := %00001000



' set I/O ports to proper direction
' P3 = JOY_CLK      (4)
' P4 = JOY_SH/LDn   (5)
' P5 = JOY_DATAOUT0 (6)
' P6 = JOY_DATAOUT1 (7)
' NES Bit Encoding
{
' step 1: set I/Os
  DIRA [3] := 1 ' output
  DIRA [4] := 1 ' output
  DIRA [5] := 0 ' input
  DIRA [6] := 0 ' input
  OUTA [3] := 0 ' JOY_CLK = 0
  OUTA [4] := 0 ' JOY_SH/LDn = 0
  OUTA [4] := 1 ' JOY_SH/LDn = 1
  OUTA [4] := 0 ' JOY_SH/LDn = 0
' data is now ready to shift out
' first bit is ready
  pad_bits := 0
  pad_bits := INA[5] | (INA[6] << 8)
' step 7: read next 7 bits
  repeat i from 0 to 6
    OUTA [3] := 1 ' JOY_CLK = 1
    OUTA [3] := 0 ' JOY_CLK = 0
    pad_bits := (pad_bits<<1) + ( INA[5] | (INA[6] << 8) )
' invert bits to make positive logic
  pad_bits := (!pad_bits & $FFFF)
  if pad_bits&$ff==$ff
    pad_bits:=pad_bits&$ff00
  if pad_bits&$ff00==$ff00
    pad_bits:=pad_bits&$ff
}
' Keyboard (mapped onto NES buttons)
    if(key.keystate($C2))       'Up Arrow
      pad_bits|=NES_UP
    if(key.keystate($C3))       'Down Arrow
      pad_bits|=NES_DOWN
    if(key.keystate($C0))       'Left Arrow
      pad_bits|=NES_LEFT
    if(key.keystate($C1))       'Right Arrow
      pad_bits|=NES_RIGHT
    if(key.keystate($0D))       'Enter
      pad_bits|=NES_START
    if(key.keystate(" "))       'Space
      pad_bits|=NES_A

DAT

here                    byte    "here"

gemtypes                byte    0,1,2,3,4,3,2,1
gemoffsets              word    6<<8+24,8<<8+24,10<<8+24,12<<8+24,14<<8+24,0,0,0
gempals                 byte    $44,$46,$43,$45,$42,0,0,0    

p1gamesetting           byte    $c7
p2gamesetting           byte    $47
keyboardsetting         byte    $c7
joysticksetting         byte    $47

lives1text              byte    "4",0
lives2text              byte    "5",0

score1txt               byte    "000000",0,0
score2txt               byte    "000000",0,0
hiscoretxt              byte    "000000",0,0

add25txt                byte    "000025",0,0
add100txt               byte    "000100",0,0
add250txt               byte    "000250",0,0

baddyscorestxt          byte    "000025",0,0    'score to add
                        byte    "000080",0,1
                        byte    "000040",0,2
                        byte    "000055",0,3
                        byte    "000050",0,4
                        byte    "000060",0,5
                        byte    "000025",0,6
                        byte    "000050",0,7
    
font                    file    "SpectrumFont.bin"

Screen                  file    "JetPacRaw.scr"
SpritesScreen           file    "JetPacSpritesRaw.scr"

jetpacframes            word    $000,$003,$006,$009
                        word    $00c,$00f,$012,$015
                        word    $300,$303,$306,$309
                        word    $30c,$30f,$312,$315

bgmusic                 'file    "yma-dreams.hmus"

                                'Wav 'Len 'Fre 'Vol 'LFO 'LFW 'FMa 'AMa
SoundFX1                byte    $06, $FF, $5F, $0F, $01, $03, $01, $00  
                                'Att 'Dec 'Sus 'Rel
                        byte    $C9, $28, $00, $e0

                                'Wav 'Len 'Fre 'Vol 'LFO 'LFW 'FMa 'AMa
RocketFX1               byte    $05, $ff, $06, $0F, $01, $03, $01, $05
                                'Att 'Dec 'Sus 'Rel
                        byte    $F1, $24, $00, $FF

                                'Wav 'Len 'Fre 'Vol 'LFO 'LFW 'FMa 'AMa
RocketFX2               byte    $05, $ff, $09, $0F, $01, $04, $01, $05
                                'Att 'Dec 'Sus 'Rel
                        byte    $F1, $24, $00, $FF

                                'Wav 'Len 'Fre 'Vol 'LFO 'LFW 'FMa 'AMa
RocketFX3               byte    $05, $ff, $0c, $0F, $01, $05, $01, $05
                                'Att 'Dec 'Sus 'Rel
                        byte    $F1, $24, $00, $FF

                                'Wav 'Len 'Fre 'Vol 'LFO 'LFW 'FMa 'AMa
TeleportFX              byte    $06, $FF, $5F, $0F, $01, $03, $01, $00  
                                'Att 'Dec 'Sus 'Rel
                        byte    $FF, $14, $00, $FF

                                'Wav 'Len 'Fre 'Vol 'LFO 'LFW 'FMa 'AMa
TelephoneFX             byte    $05, $15, $4F, $0F, $01, $04, $05, $00  
                                'Att 'Dec 'Sus 'Rel
                        byte    $FF, $00, $00, $FF                                              

                                'Wav 'Len 'Fre 'Vol 'LFO 'LFW 'FMa 'AMa
HeartBeatFX             byte    $00, $FF, $06, $0F, $09, $FF, $04, $05
                                'Att 'Dec 'Sus 'Rel
                        byte    $F1, $F4, $00, $0F
                        byte    $F1, $78, $3C, $00, $00, $00, $F1, $78, $3C, $00, $00, $00, $00, $00, $00, $00

                                'Wav 'Len 'Fre 'Vol 'LFO 'LFW 'FMa 'AMa
KillBadFX1              byte    $09, $ff, $1f, $0F, $09, $ff, $01, $05
                                'Att 'Dec 'Sus 'Rel
                        byte    $F1, $20, $03, $f8

                                'Wav 'Len 'Fre 'Vol 'LFO 'LFW 'FMa 'AMa
WaterDropFX             byte    $05, $ff, $06, $0F, $01, $03, $04, $05
                                'Att 'Dec 'Sus 'Rel
                        byte    $F1, $F4, $01, $f0
                        
